﻿//////////////////////////////////////////////
// StreamOutputDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class StreamOutputDescriptor : public nkExport::Exportable
	{
		public :
	
			// Constructor
			StreamOutputDescriptor () noexcept ;

			// Getters
			unsigned int getStream () const ;
			nkMemory::StringView getSemanticName () const ;
			unsigned int getSemanticIndex () const ;
			unsigned char getStartComponent () const ;
			unsigned char getComponentCount () const ;
			unsigned char getOutputSlot () const ;

			// Setters
			void setStream (unsigned int value) ;
			void setSemanticName (const nkMemory::StringView& value) ;
			void setSemanticIndex (unsigned int value) ;
			void setStartComponent (unsigned char value) ;
			void setComponentCount (unsigned char value) ;
			void setOutputSlot (unsigned char value) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Attributs
			// Stream nb
			unsigned int _stream ;

			nkMemory::String _semanticName ;
			unsigned int _semanticIndex ;

			unsigned char _startComponent ;
			unsigned char _componentCount ;
			unsigned char _outputSlot ;
	} ;
}